<?php
/*--------------------------------------------------------------------
 Reader.php 2020-2-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Exceptions\OptionValueIdDoesNotExistsException;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\AttributesModelDto;
use Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\DTO\OptionValuesIdDto;

/**
 * Class Reader
 * @package Gambio\Shop\Attributes\SellingUnitModel\Database\Repository\Readers
 */
class Reader implements ReaderInterface
{
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * Reader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function attributeModelByOptionValuesId(OptionValuesIdDto $dto): AttributesModelDto
    {
        $optionValuesId = $dto->optionValuesId();
        $queryResult = $this->connection->createQueryBuilder()
            ->select('attributes_model')
            ->from('products_attributes')
            ->where('options_values_id=' . $optionValuesId)
            ->execute();
        
        if ($queryResult->rowCount() === 0) {
            
            throw new OptionValueIdDoesNotExistsException($optionValuesId . ' not found');
        }
        
        $model = $queryResult->fetch(0)['attributes_model'];
        
        return new AttributesModelDto($model);
    }
}